<?php

namespace Database\Seeders;

use App\Models\Service;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ServiceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $services = [
            [
                'name' => 'Hearing Evaluation',
                'slug' => 'hearing-evaluation',
                'description' => 'Comprehensive hearing tests and evaluations to diagnose hearing loss and related conditions.',
                'full_description' => 'Our hearing evaluation services include comprehensive audiometric testing, tympanometry, and otoacoustic emissions testing. We assess all types of hearing loss and provide personalized treatment recommendations.',
                'icon' => 'bi bi-earbuds',
                'sort_order' => 1,
                'is_active' => true,
            ],
            [
                'name' => 'Sinus Treatment',
                'slug' => 'sinus-treatment',
                'description' => 'Advanced diagnosis and treatment for chronic sinusitis, nasal polyps, and sinus infections.',
                'full_description' => 'We offer both medical and surgical treatments for sinus conditions. Our services include endoscopic sinus surgery, balloon sinuplasty, and medical management of chronic sinusitis.',
                'icon' => 'bi bi-heart-pulse',
                'sort_order' => 2,
                'is_active' => true,
            ],
            [
                'name' => 'Tonsillectomy & Adenoidectomy',
                'slug' => 'tonsillectomy-adenoidectomy',
                'description' => 'Surgical removal of tonsils and adenoids for patients with recurrent infections or breathing problems.',
                'full_description' => 'Our experienced surgeons perform tonsillectomy and adenoidectomy procedures using the latest techniques. We provide comprehensive pre and post-operative care to ensure optimal outcomes.',
                'icon' => 'bi bi-hospital',
                'sort_order' => 3,
                'is_active' => true,
            ],
            [
                'name' => 'Voice & Swallowing Disorders',
                'slug' => 'voice-swallowing-disorders',
                'description' => 'Diagnosis and treatment of voice disorders, hoarseness, and swallowing difficulties.',
                'full_description' => 'We specialize in treating voice and swallowing disorders through comprehensive evaluation including laryngoscopy and swallowing studies. Treatment options include voice therapy, medication, and surgical interventions when necessary.',
                'icon' => 'bi bi-mic',
                'sort_order' => 4,
                'is_active' => true,
            ],
            [
                'name' => 'Ear Surgery',
                'slug' => 'ear-surgery',
                'description' => 'Surgical procedures for ear conditions including tympanoplasty, mastoidectomy, and stapedectomy.',
                'full_description' => 'Our ear surgery services cover a wide range of procedures to treat hearing loss, chronic ear infections, and structural ear problems. We use advanced microsurgical techniques for optimal results.',
                'icon' => 'bi bi-headphones',
                'sort_order' => 5,
                'is_active' => true,
            ],
            [
                'name' => 'Allergy Testing & Treatment',
                'slug' => 'allergy-testing-treatment',
                'description' => 'Comprehensive allergy testing and immunotherapy for allergic rhinitis and related conditions.',
                'full_description' => 'We provide comprehensive allergy testing including skin prick tests and blood tests. Treatment options include allergen avoidance, medications, and immunotherapy (allergy shots) for long-term relief.',
                'icon' => 'bi bi-flower1',
                'sort_order' => 6,
                'is_active' => true,
            ],
            [
                'name' => 'Sleep Apnea Treatment',
                'slug' => 'sleep-apnea-treatment',
                'description' => 'Diagnosis and treatment of sleep apnea and snoring using CPAP, oral appliances, and surgery.',
                'full_description' => 'We evaluate and treat sleep apnea through sleep studies and offer various treatment options including CPAP therapy, oral appliances, and surgical procedures like UPPP and nasal surgery.',
                'icon' => 'bi bi-moon-stars',
                'sort_order' => 7,
                'is_active' => true,
            ],
            [
                'name' => 'Thyroid & Parathyroid Surgery',
                'slug' => 'thyroid-parathyroid-surgery',
                'description' => 'Surgical treatment for thyroid and parathyroid disorders including tumors and hyperparathyroidism.',
                'full_description' => 'Our surgeons specialize in thyroid and parathyroid surgery using minimally invasive techniques when possible. We provide comprehensive evaluation and post-operative care for optimal patient outcomes.',
                'icon' => 'bi bi-heart',
                'sort_order' => 8,
                'is_active' => true,
            ],
        ];

        foreach ($services as $service) {
            Service::create($service);
        }
    }
}
